"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    replication_subnet_group_identifier: str,
    replication_subnet_group_description: str,
    subnet_ids: List,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a replication subnet group given a list of the subnet IDs in a VPC.

    Args:
        replication_subnet_group_identifier(str): The name for the replication subnet group. This value is stored as a lowercase string. Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens. Must not be "default". Example: mySubnetgroup .
        replication_subnet_group_description(str): The description for the subnet group.
        subnet_ids(List): One or more subnet IDs to be assigned to the subnet group.
        tags(List, optional): One or more tags to be assigned to the subnet group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.subnet_group.create(
                ctx,
                replication_subnet_group_identifier=value,
                replication_subnet_group_description=value,
                subnet_ids=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.subnet_group.create replication_subnet_group_identifier=value, replication_subnet_group_description=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="create_replication_subnet_group",
        op_kwargs={
            "ReplicationSubnetGroupIdentifier": replication_subnet_group_identifier,
            "ReplicationSubnetGroupDescription": replication_subnet_group_description,
            "SubnetIds": subnet_ids,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, replication_subnet_group_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a subnet group.

    Args:
        replication_subnet_group_identifier(str): The subnet group name of the replication instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.subnet_group.delete(
                ctx, replication_subnet_group_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.subnet_group.delete replication_subnet_group_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="delete_replication_subnet_group",
        op_kwargs={
            "ReplicationSubnetGroupIdentifier": replication_subnet_group_identifier
        },
    )


async def describe_all(
    hub, ctx, filters: List = None, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the replication subnet groups.

    Args:
        filters(List, optional): Filters applied to replication subnet groups. Valid filter names: replication-subnet-group-id. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.subnet_group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.subnet_group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_replication_subnet_groups",
        op_kwargs={"Filters": filters, "MaxRecords": max_records, "Marker": marker},
    )


async def modify(
    hub,
    ctx,
    replication_subnet_group_identifier: str,
    subnet_ids: List,
    replication_subnet_group_description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the settings for the specified replication subnet group.

    Args:
        replication_subnet_group_identifier(str): The name of the replication instance subnet group.
        replication_subnet_group_description(str, optional): A description for the replication instance subnet group. Defaults to None.
        subnet_ids(List): A list of subnet IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.subnet_group.modify(
                ctx, replication_subnet_group_identifier=value, subnet_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.subnet_group.modify replication_subnet_group_identifier=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="modify_replication_subnet_group",
        op_kwargs={
            "ReplicationSubnetGroupIdentifier": replication_subnet_group_identifier,
            "ReplicationSubnetGroupDescription": replication_subnet_group_description,
            "SubnetIds": subnet_ids,
        },
    )
