"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    replication_instance_identifier: str,
    replication_instance_class: str,
    allocated_storage: int = None,
    vpc_security_group_ids: List = None,
    availability_zone: str = None,
    replication_subnet_group_identifier: str = None,
    preferred_maintenance_window: str = None,
    multi_az: bool = None,
    engine_version: str = None,
    auto_minor_version_upgrade: bool = None,
    tags: List = None,
    kms_key_id: str = None,
    publicly_accessible: bool = None,
    dns_name_servers: str = None,
    resource_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates the replication instance using the specified parameters. DMS requires that your account have certain roles with appropriate permissions before you can create a replication instance. For information on the required roles, see Creating the IAM Roles to Use With the CLI and DMS API. For information on the required permissions, see IAM Permissions Needed to Use DMS.

    Args:
        replication_instance_identifier(str): The replication instance identifier. This parameter is stored as a lowercase string. Constraints:   Must contain 1-63 alphanumeric characters or hyphens.   First character must be a letter.   Can't end with a hyphen or contain two consecutive hyphens.   Example: myrepinstance .
        allocated_storage(int, optional): The amount of storage (in gigabytes) to be initially allocated for the replication instance. Defaults to None.
        replication_instance_class(str): The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to "dms.c4.large". For more information on the settings and capacities for the available replication instance classes, see  Selecting the right DMS replication instance for your migration. .
        vpc_security_group_ids(List, optional):  Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. . Defaults to None.
        availability_zone(str, optional): The Availability Zone where the replication instance will be created. The default value is a random, system-chosen Availability Zone in the endpoint's Region, for example: us-east-1d . Defaults to None.
        replication_subnet_group_identifier(str, optional): A subnet group to associate with the replication instance. Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).  Format: ddd:hh24:mi-ddd:hh24:mi  Default: A 30-minute window selected at random from an 8-hour block of time per Region, occurring on a random day of the week. Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun Constraints: Minimum 30-minute window. Defaults to None.
        multi_az(bool, optional):  Specifies whether the replication instance is a Multi-AZ deployment. You can't set the AvailabilityZone parameter if the Multi-AZ parameter is set to true. . Defaults to None.
        engine_version(str, optional): The engine version number of the replication instance. If an engine version number is not specified when a replication instance is created, the default is the latest engine version available. Defaults to None.
        auto_minor_version_upgrade(bool, optional): A value that indicates whether minor engine upgrades are applied automatically to the replication instance during the maintenance window. This parameter defaults to true. Default: true . Defaults to None.
        tags(List, optional): One or more tags to be assigned to the replication instance. Defaults to None.
        kms_key_id(str, optional): An KMS key identifier that is used to encrypt the data on the replication instance. If you don't specify a value for the KmsKeyId parameter, then DMS uses your default encryption key. KMS creates the default encryption key for your account. Your account has a different default encryption key for each Region. Defaults to None.
        publicly_accessible(bool, optional):  Specifies the accessibility options for the replication instance. A value of true represents an instance with a public IP address. A value of false represents an instance with a private IP address. The default value is true. . Defaults to None.
        dns_name_servers(str, optional): A list of custom DNS name servers supported for the replication instance to access your on-premise source or target database. This list overrides the default name servers supported by the replication instance. You can specify a comma-separated list of internet addresses for up to four on-premise DNS name servers. For example: "1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4" . Defaults to None.
        resource_identifier(str, optional): A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as Example-App-ARN1. For example, this value might result in the EndpointArn value arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1. If you don't specify a ResourceIdentifier value, DMS generates a default identifier value for the end of EndpointArn. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.instance.init.create(
                ctx, replication_instance_identifier=value, replication_instance_class=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.instance.init.create replication_instance_identifier=value, replication_instance_class=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="create_replication_instance",
        op_kwargs={
            "ReplicationInstanceIdentifier": replication_instance_identifier,
            "AllocatedStorage": allocated_storage,
            "ReplicationInstanceClass": replication_instance_class,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "AvailabilityZone": availability_zone,
            "ReplicationSubnetGroupIdentifier": replication_subnet_group_identifier,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "MultiAZ": multi_az,
            "EngineVersion": engine_version,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "Tags": tags,
            "KmsKeyId": kms_key_id,
            "PubliclyAccessible": publicly_accessible,
            "DnsNameServers": dns_name_servers,
            "ResourceIdentifier": resource_identifier,
        },
    )


async def delete(hub, ctx, replication_instance_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified replication instance.  You must delete any migration tasks that are associated with the replication instance before you can delete it.

    Args:
        replication_instance_arn(str): The Amazon Resource Name (ARN) of the replication instance to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.instance.init.delete(
                ctx, replication_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.instance.init.delete replication_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="delete_replication_instance",
        op_kwargs={"ReplicationInstanceArn": replication_instance_arn},
    )


async def describe_all(
    hub, ctx, filters: List = None, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about replication instances for your account in the current region.

    Args:
        filters(List, optional): Filters applied to replication instances. Valid filter names: replication-instance-arn | replication-instance-id | replication-instance-class | engine-version. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.instance.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.instance.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_replication_instances",
        op_kwargs={"Filters": filters, "MaxRecords": max_records, "Marker": marker},
    )


async def modify(
    hub,
    ctx,
    replication_instance_arn: str,
    allocated_storage: int = None,
    apply_immediately: bool = None,
    replication_instance_class: str = None,
    vpc_security_group_ids: List = None,
    preferred_maintenance_window: str = None,
    multi_az: bool = None,
    engine_version: str = None,
    allow_major_version_upgrade: bool = None,
    auto_minor_version_upgrade: bool = None,
    replication_instance_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the replication instance to apply new settings. You can change one or more parameters by specifying these parameters and the new values in the request. Some settings are applied during the maintenance window.

    Args:
        replication_instance_arn(str): The Amazon Resource Name (ARN) of the replication instance.
        allocated_storage(int, optional): The amount of storage (in gigabytes) to be allocated for the replication instance. Defaults to None.
        apply_immediately(bool, optional): Indicates whether the changes should be applied immediately or during the next maintenance window. Defaults to None.
        replication_instance_class(str, optional): The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to "dms.c4.large". For more information on the settings and capacities for the available replication instance classes, see  Selecting the right DMS replication instance for your migration. . Defaults to None.
        vpc_security_group_ids(List, optional):  Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter does not result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied. Default: Uses existing setting Format: ddd:hh24:mi-ddd:hh24:mi Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun Constraints: Must be at least 30 minutes. Defaults to None.
        multi_az(bool, optional):  Specifies whether the replication instance is a Multi-AZ deployment. You can't set the AvailabilityZone parameter if the Multi-AZ parameter is set to true. . Defaults to None.
        engine_version(str, optional): The engine version number of the replication instance. When modifying a major engine version of an instance, also set AllowMajorVersionUpgrade to true. Defaults to None.
        allow_major_version_upgrade(bool, optional): Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage, and the change is asynchronously applied as soon as possible. This parameter must be set to true when specifying a value for the EngineVersion parameter that is a different major version than the replication instance's current version. Defaults to None.
        auto_minor_version_upgrade(bool, optional): A value that indicates that minor version upgrades are applied automatically to the replication instance during the maintenance window. Changing this parameter doesn't result in an outage, except in the case described following. The change is asynchronously applied as soon as possible.  An outage does result if these factors apply:    This parameter is set to true during the maintenance window.   A newer minor version is available.    DMS has enabled automatic patching for the given engine version.   . Defaults to None.
        replication_instance_identifier(str, optional): The replication instance identifier. This parameter is stored as a lowercase string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.instance.init.modify(
                ctx, replication_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.instance.init.modify replication_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="modify_replication_instance",
        op_kwargs={
            "ReplicationInstanceArn": replication_instance_arn,
            "AllocatedStorage": allocated_storage,
            "ApplyImmediately": apply_immediately,
            "ReplicationInstanceClass": replication_instance_class,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "MultiAZ": multi_az,
            "EngineVersion": engine_version,
            "AllowMajorVersionUpgrade": allow_major_version_upgrade,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "ReplicationInstanceIdentifier": replication_instance_identifier,
        },
    )


async def reboot(
    hub, ctx, replication_instance_arn: str, force_failover: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes available again.

    Args:
        replication_instance_arn(str): The Amazon Resource Name (ARN) of the replication instance.
        force_failover(bool, optional): If this parameter is true, the reboot is conducted through a Multi-AZ failover. (If the instance isn't configured for Multi-AZ, then you can't specify true.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.instance.init.reboot(
                ctx, replication_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.instance.init.reboot replication_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="reboot_replication_instance",
        op_kwargs={
            "ReplicationInstanceArn": replication_instance_arn,
            "ForceFailover": force_failover,
        },
    )
