"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, endpoint_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the status of the RefreshSchemas operation.

    Args:
        endpoint_arn(str): The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.refresh_schemas_status.describe(ctx, endpoint_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.refresh_schemas_status.describe endpoint_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_refresh_schemas_status",
        op_kwargs={"EndpointArn": endpoint_arn},
    )
