"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def apply(
    hub, ctx, replication_instance_arn: str, apply_action: str, opt_in_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Applies a pending maintenance action to a resource (for example, to a replication instance).

    Args:
        replication_instance_arn(str): The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action applies to.
        apply_action(str): The pending maintenance action to apply to this resource.
        opt_in_type(str): A value that specifies the type of opt-in request, or undoes an opt-in request. You can't undo an opt-in request of type immediate. Valid values:    immediate - Apply the maintenance action immediately.    next-maintenance - Apply the maintenance action during the next maintenance window for the resource.    undo-opt-in - Cancel any existing next-maintenance opt-in requests.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.pending_maintenance_action.apply(
                ctx, replication_instance_arn=value, apply_action=value, opt_in_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.pending_maintenance_action.apply replication_instance_arn=value, apply_action=value, opt_in_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="apply_pending_maintenance_action",
        op_kwargs={
            "ReplicationInstanceArn": replication_instance_arn,
            "ApplyAction": apply_action,
            "OptInType": opt_in_type,
        },
    )


async def describe_all(
    hub,
    ctx,
    replication_instance_arn: str = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    For internal use only

    Args:
        replication_instance_arn(str, optional): The Amazon Resource Name (ARN) of the replication instance. Defaults to None.
        filters(List, optional): . Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.pending_maintenance_action.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.pending_maintenance_action.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_pending_maintenance_actions",
        op_kwargs={
            "ReplicationInstanceArn": replication_instance_arn,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )
