"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    source_identifier: str = None,
    source_type: str = None,
    start_time: str = None,
    end_time: str = None,
    duration: int = None,
    event_categories: List = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists events for a given source identifier and source type. You can also specify a start and end time. For more information on DMS events, see Working with Events and Notifications in the Database Migration Service User Guide.

    Args:
        source_identifier(str, optional):  The identifier of an event source. Defaults to None.
        source_type(str, optional): The type of DMS resource that generates events. Valid values: replication-instance | replication-task. Defaults to None.
        start_time(str, optional): The start time for the events to be listed. Defaults to None.
        end_time(str, optional): The end time for the events to be listed. Defaults to None.
        duration(int, optional): The duration of the events to be listed. Defaults to None.
        event_categories(List, optional): A list of event categories for the source type that you've chosen. Defaults to None.
        filters(List, optional): Filters applied to events. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.event.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.event.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_events",
        op_kwargs={
            "SourceIdentifier": source_identifier,
            "SourceType": source_type,
            "StartTime": start_time,
            "EndTime": end_time,
            "Duration": duration,
            "EventCategories": event_categories,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
