"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, source_type: str = None, filters: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of the event categories and source types in Working with Events and Notifications in the Database Migration Service User Guide.

    Args:
        source_type(str, optional):  The type of DMS resource that generates events.  Valid values: replication-instance | replication-task. Defaults to None.
        filters(List, optional): Filters applied to the event categories. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.event.category.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.event.category.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_event_categories",
        op_kwargs={"SourceType": source_type, "Filters": filters},
    )
