"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, engine_name: str, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the possible endpoint settings available when you create an endpoint for a specific database engine.

    Args:
        engine_name(str): The databse engine used for your source or target endpoint.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.endpoint.setting.describe_all(ctx, engine_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.endpoint.setting.describe_all engine_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_endpoint_settings",
        op_kwargs={
            "EngineName": engine_name,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
