"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    endpoint_identifier: str,
    endpoint_type: str,
    engine_name: str,
    username: str = None,
    password: str = None,
    server_name: str = None,
    port: int = None,
    database_name: str = None,
    extra_connection_attributes: str = None,
    kms_key_id: str = None,
    tags: List = None,
    certificate_arn: str = None,
    ssl_mode: str = None,
    service_access_role_arn: str = None,
    external_table_definition: str = None,
    dynamo_db_settings: Dict = None,
    s3_settings: Dict = None,
    dms_transfer_settings: Dict = None,
    mongo_db_settings: Dict = None,
    kinesis_settings: Dict = None,
    kafka_settings: Dict = None,
    elasticsearch_settings: Dict = None,
    neptune_settings: Dict = None,
    redshift_settings: Dict = None,
    postgre_sql_settings: Dict = None,
    my_sql_settings: Dict = None,
    oracle_settings: Dict = None,
    sybase_settings: Dict = None,
    microsoft_sql_server_settings: Dict = None,
    ibm_db2_settings: Dict = None,
    resource_identifier: str = None,
    doc_db_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an endpoint using the provided settings.  For a MySQL source or target endpoint, don't explicitly specify the database using the DatabaseName request parameter on the CreateEndpoint API call. Specifying DatabaseName when you create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.

    Args:
        endpoint_identifier(str): The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
        endpoint_type(str): The type of endpoint. Valid values are source and target.
        engine_name(str): The type of engine for the endpoint. Valid values, depending on the EndpointType value, include "mysql", "oracle", "postgres", "mariadb", "aurora", "aurora-postgresql", "redshift", "s3", "db2", "azuredb", "sybase", "dynamodb", "mongodb", "kinesis", "kafka", "elasticsearch", "docdb", "sqlserver", and "neptune".
        username(str, optional): The user name to be used to log in to the endpoint database. Defaults to None.
        password(str, optional): The password to be used to log in to the endpoint database. Defaults to None.
        server_name(str, optional): The name of the server where the endpoint database resides. Defaults to None.
        port(int, optional): The port used by the endpoint database. Defaults to None.
        database_name(str, optional): The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName. Defaults to None.
        extra_connection_attributes(str, optional): Additional attributes associated with the connection. Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see Working with DMS Endpoints in the Database Migration Service User Guide. . Defaults to None.
        kms_key_id(str, optional): An KMS key identifier that is used to encrypt the connection parameters for the endpoint. If you don't specify a value for the KmsKeyId parameter, then DMS uses your default encryption key. KMS creates the default encryption key for your account. Your account has a different default encryption key for each Region. Defaults to None.
        tags(List, optional): One or more tags to be assigned to the endpoint. Defaults to None.
        certificate_arn(str, optional): The Amazon Resource Name (ARN) for the certificate. Defaults to None.
        ssl_mode(str, optional): The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is none . Defaults to None.
        service_access_role_arn(str, optional):  The Amazon Resource Name (ARN) for the service access role that you want to use to create the endpoint. The role must allow the iam:PassRole action. Defaults to None.
        external_table_definition(str, optional): The external table definition. . Defaults to None.
        dynamo_db_settings(Dict, optional): Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see Using Object Mapping to Migrate Data to DynamoDB in the Database Migration Service User Guide. . Defaults to None.
        s3_settings(Dict, optional): Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see Extra Connection Attributes When Using Amazon S3 as a Target for DMS in the Database Migration Service User Guide. . Defaults to None.
        dms_transfer_settings(Dict, optional): The settings in JSON format for the DMS transfer type of source endpoint.  Possible settings include the following:    ServiceAccessRoleArn - The IAM role that has permission to access the Amazon S3 bucket. The role must allow the iam:PassRole action.    BucketName - The name of the S3 bucket to use.   Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string,BucketName=string  JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string", "BucketName": "string", }  . Defaults to None.
        mongo_db_settings(Dict, optional): Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see Endpoint configuration settings when using MongoDB as a source for Database Migration Service in the Database Migration Service User Guide. . Defaults to None.
        kinesis_settings(Dict, optional): Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see Using object mapping to migrate data to a Kinesis data stream in the Database Migration Service User Guide. . Defaults to None.
        kafka_settings(Dict, optional): Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see Using object mapping to migrate data to a Kafka topic in the Database Migration Service User Guide. . Defaults to None.
        elasticsearch_settings(Dict, optional): Settings in JSON format for the target Elasticsearch endpoint. For more information about the available settings, see Extra Connection Attributes When Using Elasticsearch as a Target for DMS in the Database Migration Service User Guide. Defaults to None.
        neptune_settings(Dict, optional): Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target in the Database Migration Service User Guide. . Defaults to None.
        redshift_settings(Dict, optional): Provides information that defines an Amazon Redshift endpoint. Defaults to None.
        postgre_sql_settings(Dict, optional): Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see Extra connection attributes when using PostgreSQL as a source for DMS and  Extra connection attributes when using PostgreSQL as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        my_sql_settings(Dict, optional): Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see Extra connection attributes when using MySQL as a source for DMS and Extra connection attributes when using a MySQL-compatible database as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        oracle_settings(Dict, optional): Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see Extra connection attributes when using Oracle as a source for DMS and  Extra connection attributes when using Oracle as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        sybase_settings(Dict, optional): Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see Extra connection attributes when using SAP ASE as a source for DMS and Extra connection attributes when using SAP ASE as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        microsoft_sql_server_settings(Dict, optional): Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see Extra connection attributes when using SQL Server as a source for DMS and  Extra connection attributes when using SQL Server as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        ibm_db2_settings(Dict, optional): Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see Extra connection attributes when using Db2 LUW as a source for DMS in the Database Migration Service User Guide. . Defaults to None.
        resource_identifier(str, optional): A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as Example-App-ARN1. For example, this value might result in the EndpointArn value arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1. If you don't specify a ResourceIdentifier value, DMS generates a default identifier value for the end of EndpointArn. Defaults to None.
        doc_db_settings(Dict, optional): Provides information that defines a DocumentDB endpoint. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.endpoint.init.create(
                ctx, endpoint_identifier=value, endpoint_type=value, engine_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.endpoint.init.create endpoint_identifier=value, endpoint_type=value, engine_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="create_endpoint",
        op_kwargs={
            "EndpointIdentifier": endpoint_identifier,
            "EndpointType": endpoint_type,
            "EngineName": engine_name,
            "Username": username,
            "Password": password,
            "ServerName": server_name,
            "Port": port,
            "DatabaseName": database_name,
            "ExtraConnectionAttributes": extra_connection_attributes,
            "KmsKeyId": kms_key_id,
            "Tags": tags,
            "CertificateArn": certificate_arn,
            "SslMode": ssl_mode,
            "ServiceAccessRoleArn": service_access_role_arn,
            "ExternalTableDefinition": external_table_definition,
            "DynamoDbSettings": dynamo_db_settings,
            "S3Settings": s3_settings,
            "DmsTransferSettings": dms_transfer_settings,
            "MongoDbSettings": mongo_db_settings,
            "KinesisSettings": kinesis_settings,
            "KafkaSettings": kafka_settings,
            "ElasticsearchSettings": elasticsearch_settings,
            "NeptuneSettings": neptune_settings,
            "RedshiftSettings": redshift_settings,
            "PostgreSQLSettings": postgre_sql_settings,
            "MySQLSettings": my_sql_settings,
            "OracleSettings": oracle_settings,
            "SybaseSettings": sybase_settings,
            "MicrosoftSQLServerSettings": microsoft_sql_server_settings,
            "IBMDb2Settings": ibm_db2_settings,
            "ResourceIdentifier": resource_identifier,
            "DocDbSettings": doc_db_settings,
        },
    )


async def delete(hub, ctx, endpoint_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified endpoint.  All tasks associated with the endpoint must be deleted before you can delete the endpoint.

    Args:
        endpoint_arn(str): The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.endpoint.init.delete(ctx, endpoint_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.endpoint.init.delete endpoint_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="delete_endpoint",
        op_kwargs={"EndpointArn": endpoint_arn},
    )


async def describe_all(
    hub, ctx, filters: List = None, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the endpoints for your account in the current region.

    Args:
        filters(List, optional): Filters applied to the endpoints. Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.endpoint.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.endpoint.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_endpoints",
        op_kwargs={"Filters": filters, "MaxRecords": max_records, "Marker": marker},
    )


async def modify(
    hub,
    ctx,
    endpoint_arn: str,
    endpoint_identifier: str = None,
    endpoint_type: str = None,
    engine_name: str = None,
    username: str = None,
    password: str = None,
    server_name: str = None,
    port: int = None,
    database_name: str = None,
    extra_connection_attributes: str = None,
    certificate_arn: str = None,
    ssl_mode: str = None,
    service_access_role_arn: str = None,
    external_table_definition: str = None,
    dynamo_db_settings: Dict = None,
    s3_settings: Dict = None,
    dms_transfer_settings: Dict = None,
    mongo_db_settings: Dict = None,
    kinesis_settings: Dict = None,
    kafka_settings: Dict = None,
    elasticsearch_settings: Dict = None,
    neptune_settings: Dict = None,
    redshift_settings: Dict = None,
    postgre_sql_settings: Dict = None,
    my_sql_settings: Dict = None,
    oracle_settings: Dict = None,
    sybase_settings: Dict = None,
    microsoft_sql_server_settings: Dict = None,
    ibm_db2_settings: Dict = None,
    doc_db_settings: Dict = None,
    exact_settings: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified endpoint.  For a MySQL source or target endpoint, don't explicitly specify the database using the DatabaseName request parameter on the ModifyEndpoint API call. Specifying DatabaseName when you modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.

    Args:
        endpoint_arn(str): The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
        endpoint_identifier(str, optional): The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens. Defaults to None.
        endpoint_type(str, optional): The type of endpoint. Valid values are source and target. Defaults to None.
        engine_name(str, optional): The type of engine for the endpoint. Valid values, depending on the EndpointType, include "mysql", "oracle", "postgres", "mariadb", "aurora", "aurora-postgresql", "redshift", "s3", "db2", "azuredb", "sybase", "dynamodb", "mongodb", "kinesis", "kafka", "elasticsearch", "documentdb", "sqlserver", and "neptune". Defaults to None.
        username(str, optional): The user name to be used to login to the endpoint database. Defaults to None.
        password(str, optional): The password to be used to login to the endpoint database. Defaults to None.
        server_name(str, optional): The name of the server where the endpoint database resides. Defaults to None.
        port(int, optional): The port used by the endpoint database. Defaults to None.
        database_name(str, optional): The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName. Defaults to None.
        extra_connection_attributes(str, optional): Additional attributes associated with the connection. To reset this parameter, pass the empty string ("") as an argument. Defaults to None.
        certificate_arn(str, optional): The Amazon Resource Name (ARN) of the certificate used for SSL connection. Defaults to None.
        ssl_mode(str, optional): The SSL mode used to connect to the endpoint. The default value is none. Defaults to None.
        service_access_role_arn(str, optional):  The Amazon Resource Name (ARN) for the IAM role you want to use to modify the endpoint. The role must allow the iam:PassRole action. Defaults to None.
        external_table_definition(str, optional): The external table definition. Defaults to None.
        dynamo_db_settings(Dict, optional): Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see Using Object Mapping to Migrate Data to DynamoDB in the Database Migration Service User Guide. . Defaults to None.
        s3_settings(Dict, optional): Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see Extra Connection Attributes When Using Amazon S3 as a Target for DMS in the Database Migration Service User Guide. . Defaults to None.
        dms_transfer_settings(Dict, optional): The settings in JSON format for the DMS transfer type of source endpoint.  Attributes include the following:   serviceAccessRoleArn - The Identity and Access Management (IAM) role that has permission to access the Amazon S3 bucket. The role must allow the iam:PassRole action.   BucketName - The name of the S3 bucket to use.   Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string ,BucketName=string  JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string", "BucketName": "string"}  . Defaults to None.
        mongo_db_settings(Dict, optional): Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see the configuration properties section in Endpoint configuration settings when using MongoDB as a source for Database Migration Service in the Database Migration Service User Guide. . Defaults to None.
        kinesis_settings(Dict, optional): Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see Using object mapping to migrate data to a Kinesis data stream in the Database Migration Service User Guide. . Defaults to None.
        kafka_settings(Dict, optional): Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see Using object mapping to migrate data to a Kafka topic in the Database Migration Service User Guide. . Defaults to None.
        elasticsearch_settings(Dict, optional): Settings in JSON format for the target Elasticsearch endpoint. For more information about the available settings, see Extra Connection Attributes When Using Elasticsearch as a Target for DMS in the Database Migration Service User Guide. . Defaults to None.
        neptune_settings(Dict, optional): Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target in the Database Migration Service User Guide. . Defaults to None.
        redshift_settings(Dict, optional): Provides information that defines an Amazon Redshift endpoint. Defaults to None.
        postgre_sql_settings(Dict, optional): Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see Extra connection attributes when using PostgreSQL as a source for DMS and  Extra connection attributes when using PostgreSQL as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        my_sql_settings(Dict, optional): Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see Extra connection attributes when using MySQL as a source for DMS and Extra connection attributes when using a MySQL-compatible database as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        oracle_settings(Dict, optional): Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see Extra connection attributes when using Oracle as a source for DMS and  Extra connection attributes when using Oracle as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        sybase_settings(Dict, optional): Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see Extra connection attributes when using SAP ASE as a source for DMS and Extra connection attributes when using SAP ASE as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        microsoft_sql_server_settings(Dict, optional): Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see Extra connection attributes when using SQL Server as a source for DMS and  Extra connection attributes when using SQL Server as a target for DMS in the Database Migration Service User Guide. . Defaults to None.
        ibm_db2_settings(Dict, optional): Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see Extra connection attributes when using Db2 LUW as a source for DMS in the Database Migration Service User Guide. . Defaults to None.
        doc_db_settings(Dict, optional): Settings in JSON format for the source DocumentDB endpoint. For more information about the available settings, see the configuration properties section in  Using DocumentDB as a Target for Database Migration Service  in the Database Migration Service User Guide. . Defaults to None.
        exact_settings(bool, optional): If this attribute is Y, the current call to ModifyEndpoint replaces all existing endpoint settings with the exact settings that you specify in this call. If this attribute is N, the current call to ModifyEndpoint does two things:    It replaces any endpoint settings that already exist with new values, for settings with the same names.   It creates new endpoint settings that you specify in the call, for settings with different names.    For example, if you call create-endpoint ... --endpoint-settings '{"a":1}' ..., the endpoint has the following endpoint settings: '{"a":1}'. If you then call modify-endpoint ... --endpoint-settings '{"b":2}' ... for the same endpoint, the endpoint has the following settings: '{"a":1,"b":2}'.  However, suppose that you follow this with a call to modify-endpoint ... --endpoint-settings '{"b":2}' --exact-settings ... for that same endpoint again. Then the endpoint has the following settings: '{"b":2}'. All existing settings are replaced with the exact settings that you specify. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.endpoint.init.modify(ctx, endpoint_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.endpoint.init.modify endpoint_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="modify_endpoint",
        op_kwargs={
            "EndpointArn": endpoint_arn,
            "EndpointIdentifier": endpoint_identifier,
            "EndpointType": endpoint_type,
            "EngineName": engine_name,
            "Username": username,
            "Password": password,
            "ServerName": server_name,
            "Port": port,
            "DatabaseName": database_name,
            "ExtraConnectionAttributes": extra_connection_attributes,
            "CertificateArn": certificate_arn,
            "SslMode": ssl_mode,
            "ServiceAccessRoleArn": service_access_role_arn,
            "ExternalTableDefinition": external_table_definition,
            "DynamoDbSettings": dynamo_db_settings,
            "S3Settings": s3_settings,
            "DmsTransferSettings": dms_transfer_settings,
            "MongoDbSettings": mongo_db_settings,
            "KinesisSettings": kinesis_settings,
            "KafkaSettings": kafka_settings,
            "ElasticsearchSettings": elasticsearch_settings,
            "NeptuneSettings": neptune_settings,
            "RedshiftSettings": redshift_settings,
            "PostgreSQLSettings": postgre_sql_settings,
            "MySQLSettings": my_sql_settings,
            "OracleSettings": oracle_settings,
            "SybaseSettings": sybase_settings,
            "MicrosoftSQLServerSettings": microsoft_sql_server_settings,
            "IBMDb2Settings": ibm_db2_settings,
            "DocDbSettings": doc_db_settings,
            "ExactSettings": exact_settings,
        },
    )
