"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, endpoint_arn: str, replication_instance_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the connection between a replication instance and an endpoint.

    Args:
        endpoint_arn(str): The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
        replication_instance_arn(str): The Amazon Resource Name (ARN) of the replication instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.connection.delete(
                ctx, endpoint_arn=value, replication_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.connection.delete endpoint_arn=value, replication_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="delete_connection",
        op_kwargs={
            "EndpointArn": endpoint_arn,
            "ReplicationInstanceArn": replication_instance_arn,
        },
    )


async def describe_all(
    hub, ctx, filters: List = None, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the status of the connections that have been made between the replication instance and an endpoint. Connections are created when you test an endpoint.

    Args:
        filters(List, optional): The filters applied to the connection. Valid filter names: endpoint-arn | replication-instance-arn. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.connection.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.connection.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_connections",
        op_kwargs={"Filters": filters, "MaxRecords": max_records, "Marker": marker},
    )


async def test(hub, ctx, replication_instance_arn: str, endpoint_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Tests the connection between the replication instance and the endpoint.

    Args:
        replication_instance_arn(str): The Amazon Resource Name (ARN) of the replication instance.
        endpoint_arn(str): The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.connection.test(
                ctx, replication_instance_arn=value, endpoint_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.connection.test replication_instance_arn=value, endpoint_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="test_connection",
        op_kwargs={
            "ReplicationInstanceArn": replication_instance_arn,
            "EndpointArn": endpoint_arn,
        },
    )
