"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def delete(hub, ctx, certificate_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified certificate.

    Args:
        certificate_arn(str): The Amazon Resource Name (ARN) of the deleted certificate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.certificate.delete(ctx, certificate_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.certificate.delete certificate_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="delete_certificate",
        op_kwargs={"CertificateArn": certificate_arn},
    )


async def describe_all(
    hub, ctx, filters: List = None, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a description of the certificate.

    Args:
        filters(List, optional): Filters applied to the certificates described in the form of key-value pairs. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 10. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.certificate.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.certificate.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_certificates",
        op_kwargs={"Filters": filters, "MaxRecords": max_records, "Marker": marker},
    )


async def import_(
    hub,
    ctx,
    certificate_identifier: str,
    certificate_pem: str = None,
    certificate_wallet: bytes = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Uploads the specified certificate.

    Args:
        certificate_identifier(str): A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
        certificate_pem(str, optional): The contents of a .pem file, which contains an X.509 certificate. Defaults to None.
        certificate_wallet(bytes, optional): The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a .sso file using the fileb:// prefix. You can't provide the certificate inline. . Defaults to None.
        tags(List, optional): The tags associated with the certificate. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.certificate.import(ctx, certificate_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.certificate.import certificate_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="import_certificate",
        op_kwargs={
            "CertificateIdentifier": certificate_identifier,
            "CertificatePem": certificate_pem,
            "CertificateWallet": certificate_wallet,
            "Tags": tags,
        },
    )
