"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    replication_task_arn: str = None,
    replication_instance_arn: str = None,
    source_engine_name: str = None,
    target_engine_name: str = None,
    migration_type: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of individual assessments that you can specify for a new premigration assessment run, given one or more parameters. If you specify an existing migration task, this operation provides the default individual assessments you can specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which to base a premigration assessment run. To use these migration task modeling parameters, you must specify an existing replication instance, a source database engine, a target database engine, and a migration type. This combination of parameters potentially limits the default individual assessments available for an assessment run created for a corresponding migration task. If you specify no parameters, this operation provides a list of all possible individual assessments that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of them or the operation cannot provide a list of individual assessments. The only parameter that you can specify alone is for an existing migration task. The specified task definition then determines the default list of individual assessments that you can specify in an assessment run for the task.

    Args:
        replication_task_arn(str, optional): Amazon Resource Name (ARN) of a migration task on which you want to base the default list of individual assessments. Defaults to None.
        replication_instance_arn(str, optional): ARN of a replication instance on which you want to base the default list of individual assessments. Defaults to None.
        source_engine_name(str, optional): Name of a database engine that the specified replication instance supports as a source. Defaults to None.
        target_engine_name(str, optional): Name of a database engine that the specified replication instance supports as a target. Defaults to None.
        migration_type(str, optional): Name of the migration type that each provided individual assessment must support. Defaults to None.
        max_records(int, optional): Maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. Defaults to None.
        marker(str, optional): Optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.applicable_individual_assessment.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.applicable_individual_assessment.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_applicable_individual_assessments",
        op_kwargs={
            "ReplicationTaskArn": replication_task_arn,
            "ReplicationInstanceArn": replication_instance_arn,
            "SourceEngineName": source_engine_name,
            "TargetEngineName": target_engine_name,
            "MigrationType": migration_type,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
