"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, configuration_ids: List, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.

    Args:
        configuration_ids(List): A list of configuration items that you want to tag.
        tags(List): Tags that you want to associate with one or more configuration items. Specify the tags that you want to create in a key-value format. For example:  {"key": "serverType", "value": "webServer"} .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.tags.create(ctx, configuration_ids=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.tags.create configuration_ids=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="create_tags",
        op_kwargs={"configurationIds": configuration_ids, "tags": tags},
    )


async def delete(hub, ctx, configuration_ids: List, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.

    Args:
        configuration_ids(List): A list of configuration items with tags that you want to delete.
        tags(List, optional): Tags that you want to delete from one or more configuration items. Specify the tags that you want to delete in a key-value format. For example:  {"key": "serverType", "value": "webServer"} . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.tags.delete(ctx, configuration_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.tags.delete configuration_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="delete_tags",
        op_kwargs={"configurationIds": configuration_ids, "tags": tags},
    )


async def describe(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value, passed to the optional parameter filters. There are three valid tag filter names:   tagKey   tagValue   configurationId   Also, all configuration items associated with your user account that have tags can be listed if you call DescribeTags as is without passing any parameters.

    Args:
        filters(List, optional): You can filter the list using a key-value format. You can separate these items by using logical operators. Allowed filters include tagKey, tagValue, and configurationId. . Defaults to None.
        max_results(int, optional): The total number of items to return in a single page of output. The maximum value is 100. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.tags.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.tags.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="describe_tags",
        op_kwargs={
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
