"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.

    Args:
        filters(List, optional): An array of name-value pairs that you provide to filter the results for the DescribeImportTask request to a specific subset of results. Currently, wildcard values aren't supported for filters. Defaults to None.
        max_results(int, optional): The maximum number of results that you want this request to return, up to 100. Defaults to None.
        next_token(str, optional): The token to request a specific page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.import_task.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.import_task.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="describe_import_tasks",
        op_kwargs={
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(
    hub, ctx, name: str, import_url: str, client_request_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an import task, which allows you to import details of your on-premises environment directly into AWS Migration Hub without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data, including the ability to group your devices as applications and track their migration status. To start an import request, do this:   Download the specially formatted comma separated value (CSV) import template, which you can find here: https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv.   Fill out the template with your server and application data.   Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in the CSV format.   Use the console or the StartImportTask command with the AWS CLI or one of the AWS SDKs to import the records from your file.   For more information, including step-by-step procedures, see Migration Hub Import in the AWS Application Discovery Service User Guide.  There are limits to the number of import tasks you can create (and delete) in an AWS account. For more information, see AWS Application Discovery Service Limits in the AWS Application Discovery Service User Guide.

    Args:
        client_request_token(str, optional): Optional. A unique token that you can provide to prevent the same import request from occurring more than once. If you don't provide a token, a token is automatically generated. Sending more than one StartImportTask request with the same client request token will return information about the original import task with that client request token. Defaults to None.
        name(str): A descriptive name for this request. You can use this name to filter future requests related to this import task, such as identifying applications and servers that were included in this import task. We recommend that you use a meaningful name for each import task.
        import_url(str): The URL for your import file that you've uploaded to Amazon S3.  If you're using the AWS CLI, this URL is structured as follows: s3://BucketName/ImportFileName.CSV  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.import_task.start(ctx, name=value, import_url=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.import_task.start name=value, import_url=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="start_import_task",
        op_kwargs={
            "clientRequestToken": client_request_token,
            "name": name,
            "importUrl": import_url,
        },
    )
