"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    export_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.

    Args:
        export_ids(List, optional): One or more unique identifiers used to query the status of an export request. Defaults to None.
        filters(List, optional): One or more filters.    AgentId - ID of the agent whose collected data will be exported  . Defaults to None.
        max_results(int, optional): The maximum number of volume results returned by DescribeExportTasks in paginated output. When this parameter is used, DescribeExportTasks only returns maxResults results in a single page along with a nextToken response element. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeExportTasks request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. This value is null when there are no more results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.export.task.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.export.task.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="describe_export_tasks",
        op_kwargs={
            "exportIds": export_ids,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(
    hub,
    ctx,
    export_data_format: List = None,
    filters: List = None,
    start_time: str = None,
    end_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Begins the export of discovered data to an S3 bucket.  If you specify agentIds in a filter, the task exports up to 72 hours of detailed data collected by the identified Application Discovery Agent, including network, process, and performance details. A time range for exported agent data may be set by using startTime and endTime. Export of detailed agent data is limited to five concurrently running exports.   If you do not include an agentIds filter, summary data is exported that includes both AWS Agentless Discovery Connector data and summary data from AWS Discovery Agents. Export of summary data is limited to two exports per day.

    Args:
        export_data_format(List, optional): The file format for the returned export data. Default value is CSV. Note: The GRAPHML option has been deprecated. . Defaults to None.
        filters(List, optional): If a filter is present, it selects the single agentId of the Application Discovery Agent for which data is exported. The agentId can be found in the results of the DescribeAgents API or CLI. If no filter is present, startTime and endTime are ignored and exported data includes both Agentless Discovery Connector data and summary data from Application Discovery agents. . Defaults to None.
        start_time(str, optional): The start timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, data is exported starting from the first data collected by the agent. Defaults to None.
        end_time(str, optional): The end timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, exported data includes the most recent data collected by the agent. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.export.task.start(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.export.task.start
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="start_export_task",
        op_kwargs={
            "exportDataFormat": export_data_format,
            "filters": filters,
            "startTime": start_time,
            "endTime": end_time,
        },
    )
