"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, export_ids: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     DescribeExportConfigurations is deprecated. Use DescribeImportTasks, instead.

    Args:
        export_ids(List, optional): A list of continuous export IDs to search for. Defaults to None.
        max_results(int, optional): A number between 1 and 100 specifying the maximum number of continuous export descriptions returned. Defaults to None.
        next_token(str, optional): The token from the previous call to describe-export-tasks. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.export.configuration.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.export.configuration.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="describe_export_configurations",
        op_kwargs={
            "exportIds": export_ids,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
