"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, import_task_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records that can identify servers or applications.  AWS Application Discovery Service has built-in matching logic that will identify when discovered servers match existing entries that you've previously discovered, the information for the already-existing discovered server is updated. When you delete an import task that contains records that were used to match, the information in those matched records that comes from the deleted records will also be deleted.

    Args:
        import_task_ids(List): The IDs for the import tasks that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.delete_import_data.batch(ctx, import_task_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.delete_import_data.batch import_task_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="batch_delete_import_data",
        op_kwargs={"importTaskIds": import_task_ids},
    )
