"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "data_collection_by_agent_id"


async def start(hub, ctx, agent_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Instructs the specified agents or connectors to start collecting data.

    Args:
        agent_ids(List): The IDs of the agents or connectors from which to start collecting data. If you send a request to an agent/connector ID that you do not have permission to contact, according to your AWS account, the service does not throw an exception. Instead, it returns the error in the Description field. If you send a request to multiple agents/connectors and you do not have permission to contact some of those agents/connectors, the system does not throw an exception. Instead, the system shows Failed in the Description field.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.data_collection_by_agent_id_.start(
                ctx, agent_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.data_collection_by_agent_id.start agent_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="start_data_collection_by_agent_ids",
        op_kwargs={"agentIds": agent_ids},
    )


async def stop(hub, ctx, agent_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Instructs the specified agents or connectors to stop collecting data.

    Args:
        agent_ids(List): The IDs of the agents or connectors from which to stop collecting data.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.data_collection_by_agent_id_.stop(
                ctx, agent_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.data_collection_by_agent_id.stop agent_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="stop_data_collection_by_agent_ids",
        op_kwargs={"agentIds": agent_ids},
    )
