"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, export_ids: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters.

    Args:
        export_ids(List, optional): The unique IDs assigned to the exports. Defaults to None.
        max_results(int, optional): A number between 1 and 100 specifying the maximum number of continuous export descriptions returned. Defaults to None.
        next_token(str, optional): The token from the previous call to DescribeExportTasks. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.continuous_export.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.continuous_export.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="describe_continuous_exports",
        op_kwargs={
            "exportIds": export_ids,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Start the continuous flow of agent's discovered data into Amazon Athena.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.continuous_export.start(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.continuous_export.start
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="discovery", operation="start_continuous_export", op_kwargs={}
    )


async def stop(hub, ctx, export_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stop the continuous flow of agent's discovered data into Amazon Athena.

    Args:
        export_id(str): The unique ID assigned to this export.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.continuous_export.stop(ctx, export_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.continuous_export.stop export_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="stop_continuous_export",
        op_kwargs={"exportId": export_id},
    )
