"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, application_configuration_id: str, configuration_ids: List
) -> Dict:
    r"""
    **Autogenerated function**

    Associates one or more configuration items with an application.

    Args:
        application_configuration_id(str): The configuration ID of an application with which items are to be associated.
        configuration_ids(List): The ID of each configuration item to be associated with an application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.configuration.item.to_application.associate(
                ctx, application_configuration_id=value, configuration_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.configuration.item.to_application.associate application_configuration_id=value, configuration_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="associate_configuration_items_to_application",
        op_kwargs={
            "applicationConfigurationId": application_configuration_id,
            "configurationIds": configuration_ids,
        },
    )
