"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def disassociate(
    hub, ctx, application_configuration_id: str, configuration_ids: List
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates one or more configuration items from an application.

    Args:
        application_configuration_id(str): Configuration ID of an application from which each item is disassociated.
        configuration_ids(List): Configuration ID of each item to be disassociated from an application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.configuration.item.from_application.disassociate(
                ctx, application_configuration_id=value, configuration_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.configuration.item.from_application.disassociate application_configuration_id=value, configuration_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="disassociate_configuration_items_from_application",
        op_kwargs={
            "applicationConfigurationId": application_configuration_id,
            "configurationIds": configuration_ids,
        },
    )
