"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, configuration_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves attributes for a list of configuration item IDs.  All of the supplied IDs must be for the same asset type from one of the following:   server   application   process   connection   Output fields are specific to the asset type specified. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, number of network cards, etc. For a complete list of outputs for each asset type, see Using the DescribeConfigurations Action in the AWS Application Discovery Service User Guide.

    Args:
        configuration_ids(List): One or more configuration IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.configuration.init.describe_all(
                ctx, configuration_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.configuration.init.describe_all configuration_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="describe_configurations",
        op_kwargs={"configurationIds": configuration_ids},
    )


async def export(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Deprecated. Use StartExportTask instead. Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance. This API returns an export ID that you can query using the DescribeExportConfigurations API. The system imposes a limit of two configuration exports in six hours.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.configuration.init.export(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.configuration.init.export
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="discovery", operation="export_configurations", op_kwargs={}
    )


async def list_all(
    hub,
    ctx,
    configuration_type: str,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    order_by: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of configuration items as specified by the value passed to the required parameter configurationType. Optional filtering may be applied to refine search results.

    Args:
        configuration_type(str): A valid configuration identified by Application Discovery Service. .
        filters(List, optional): You can filter the request using various logical operators and a key-value format. For example:   {"key": "serverType", "value": "webServer"}  For a complete list of filter options and guidance about using them with this action, see Using the ListConfigurations Action in the AWS Application Discovery Service User Guide. Defaults to None.
        max_results(int, optional): The total number of items to return. The maximum value is 100. Defaults to None.
        next_token(str, optional): Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned 100 items, but you set ListConfigurationsRequest$maxResults to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10. Defaults to None.
        order_by(List, optional): Certain filter criteria return output that can be sorted in ascending or descending order. For a list of output characteristics for each filter, see Using the ListConfigurations Action in the AWS Application Discovery Service User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.configuration.init.list_all(
                ctx, configuration_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.configuration.init.list_all configuration_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="list_configurations",
        op_kwargs={
            "configurationType": configuration_type,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
            "orderBy": order_by,
        },
    )
