"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, name: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an application with the given name and description.

    Args:
        name(str): Name of the application to be created.
        description(str, optional): Description of the application to be created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.application.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.application.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="create_application",
        op_kwargs={"name": name, "description": description},
    )


async def delete_multiple(hub, ctx, configuration_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a list of applications and their associations with configuration items.

    Args:
        configuration_ids(List): Configuration ID of an application to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.application.delete_multiple(
                ctx, configuration_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.application.delete_multiple configuration_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="delete_applications",
        op_kwargs={"configurationIds": configuration_ids},
    )


async def update(
    hub, ctx, configuration_id: str, name: str = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates metadata about an application.

    Args:
        configuration_id(str): Configuration ID of the application to be updated.
        name(str, optional): New name of the application to be updated. Defaults to None.
        description(str, optional): New description of the application to be updated. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.application.update(ctx, configuration_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.application.update configuration_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="update_application",
        op_kwargs={
            "configurationId": configuration_id,
            "name": name,
            "description": description,
        },
    )
