"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    agent_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists agents or connectors as specified by ID or other filters. All agents/connectors associated with your user account can be listed if you call DescribeAgents as is without passing any parameters.

    Args:
        agent_ids(List, optional): The agent or the Connector IDs for which you want information. If you specify no IDs, the system returns information about all agents/Connectors associated with your AWS user account. Defaults to None.
        filters(List, optional): You can filter the request using various logical operators and a key-value format. For example:   {"key": "collectionStatus", "value": "STARTED"} . Defaults to None.
        max_results(int, optional): The total number of agents/Connectors to return in a single page of output. The maximum value is 100. Defaults to None.
        next_token(str, optional): Token to retrieve the next set of results. For example, if you previously specified 100 IDs for DescribeAgentsRequest$agentIds but set DescribeAgentsRequest$maxResults to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.discovery.agent.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.discovery.agent.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="discovery",
        operation="describe_agents",
        op_kwargs={
            "agentIds": agent_ids,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
