"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    test_id: str = None,
    virtual_interface_id: str = None,
    bgp_peers: List = None,
    status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the virtual interface failover test history.

    Args:
        test_id(str, optional): The ID of the virtual interface failover test. Defaults to None.
        virtual_interface_id(str, optional): The ID of the virtual interface that was tested. Defaults to None.
        bgp_peers(List, optional): The BGP peers that were placed in the DOWN state during the virtual interface failover test. Defaults to None.
        status(str, optional): The status of the virtual interface failover test. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. If MaxResults is given a value larger than 100, only 100 results are returned. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.virtual.interface.test_history.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.virtual.interface.test_history.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="list_virtual_interface_test_history",
        op_kwargs={
            "testId": test_id,
            "virtualInterfaceId": virtual_interface_id,
            "bgpPeers": bgp_peers,
            "status": status,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
