"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, virtual_interface_id: str, connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address, the operation fails. Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must be migrated along with their virtual interfaces using AssociateHostedConnection. To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual interface itself or the connection to which the virtual interface is currently associated. Additionally, the requester must own the connection or LAG for the association.

    Args:
        virtual_interface_id(str): The ID of the virtual interface.
        connection_id(str): The ID of the LAG or connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.virtual.interface.init.associate(
                ctx, virtual_interface_id=value, connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.virtual.interface.init.associate virtual_interface_id=value, connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="associate_virtual_interface",
        op_kwargs={
            "virtualInterfaceId": virtual_interface_id,
            "connectionId": connection_id,
        },
    )


async def delete(hub, ctx, virtual_interface_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a virtual interface.

    Args:
        virtual_interface_id(str): The ID of the virtual interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.virtual.interface.init.delete(
                ctx, virtual_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.virtual.interface.init.delete virtual_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="delete_virtual_interface",
        op_kwargs={"virtualInterfaceId": virtual_interface_id},
    )


async def describe_all(
    hub, ctx, connection_id: str = None, virtual_interface_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Displays all virtual interfaces for an account. Virtual interfaces deleted fewer than 15 minutes before you make the request are also returned. If you specify a connection ID, only the virtual interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single virtual interface is returned. A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.

    Args:
        connection_id(str, optional): The ID of the connection. Defaults to None.
        virtual_interface_id(str, optional): The ID of the virtual interface. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.virtual.interface.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.virtual.interface.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_virtual_interfaces",
        op_kwargs={
            "connectionId": connection_id,
            "virtualInterfaceId": virtual_interface_id,
        },
    )
