"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update_multiple(hub, ctx, virtual_interface_id: str, mtu: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified attributes of the specified virtual private interface. Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual q interface supports jumbo frames, call DescribeVirtualInterfaces.

    Args:
        virtual_interface_id(str): The ID of the virtual private interface.
        mtu(int, optional): The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.virtual.interface.attribute.update_multiple(
                ctx, virtual_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.virtual.interface.attribute.update_multiple virtual_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="update_virtual_interface_attributes",
        op_kwargs={"virtualInterfaceId": virtual_interface_id, "mtu": mtu},
    )
