"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def allocate(
    hub,
    ctx,
    connection_id: str,
    owner_account: str,
    new_transit_virtual_interface_allocation: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Provisions a transit virtual interface to be owned by the specified account. Use this type of interface to connect a transit gateway to your Direct Connect gateway. The owner of a connection provisions a transit virtual interface to be owned by the specified account. After you create a transit virtual interface, it must be confirmed by the owner using ConfirmTransitVirtualInterface. Until this step has been completed, the transit virtual interface is in the requested state and is not available to handle traffic.

    Args:
        connection_id(str): The ID of the connection on which the transit virtual interface is provisioned.
        owner_account(str): The ID of the account that owns the transit virtual interface.
        new_transit_virtual_interface_allocation(Dict): Information about the transit virtual interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.transit_virtual_interface.allocate(
                ctx,
                connection_id=value,
                owner_account=value,
                new_transit_virtual_interface_allocation=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.transit_virtual_interface.allocate connection_id=value, owner_account=value, new_transit_virtual_interface_allocation=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="allocate_transit_virtual_interface",
        op_kwargs={
            "connectionId": connection_id,
            "ownerAccount": owner_account,
            "newTransitVirtualInterfaceAllocation": new_transit_virtual_interface_allocation,
        },
    )


async def confirm(
    hub, ctx, virtual_interface_id: str, direct_connect_gateway_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts ownership of a transit virtual interface created by another account.  After the owner of the transit virtual interface makes this call, the specified transit virtual interface is created and made available to handle traffic.

    Args:
        virtual_interface_id(str): The ID of the virtual interface.
        direct_connect_gateway_id(str): The ID of the Direct Connect gateway.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.transit_virtual_interface.confirm(
                ctx, virtual_interface_id=value, direct_connect_gateway_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.transit_virtual_interface.confirm virtual_interface_id=value, direct_connect_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="confirm_transit_virtual_interface",
        op_kwargs={
            "virtualInterfaceId": virtual_interface_id,
            "directConnectGatewayId": direct_connect_gateway_id,
        },
    )


async def create(
    hub, ctx, connection_id: str, new_transit_virtual_interface: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple VPCs attached to a transit gateway to a Direct Connect gateway.  If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.  Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.

    Args:
        connection_id(str): The ID of the connection.
        new_transit_virtual_interface(Dict): Information about the transit virtual interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.transit_virtual_interface.create(
                ctx, connection_id=value, new_transit_virtual_interface=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.transit_virtual_interface.create connection_id=value, new_transit_virtual_interface=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_transit_virtual_interface",
        op_kwargs={
            "connectionId": connection_id,
            "newTransitVirtualInterface": new_transit_virtual_interface,
        },
    )
