"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, resource_arns: List) -> Dict:
    r"""
    **Autogenerated function**

    Describes the tags associated with the specified Direct Connect resources.

    Args:
        resource_arns(List): The Amazon Resource Names (ARNs) of the resources.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.tags.describe(ctx, resource_arns=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.tags.describe resource_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_tags",
        op_kwargs={"resourceArns": resource_arns},
    )
