"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def allocate(
    hub,
    ctx,
    connection_id: str,
    owner_account: str,
    new_public_virtual_interface_allocation: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Provisions a public virtual interface to be owned by the specified account. The owner of a connection calls this function to provision a public virtual interface to be owned by the specified account. Virtual interfaces created using this function must be confirmed by the owner using ConfirmPublicVirtualInterface. Until this step has been completed, the virtual interface is in the confirming state and is not available to handle traffic. When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.

    Args:
        connection_id(str): The ID of the connection on which the public virtual interface is provisioned.
        owner_account(str): The ID of the account that owns the public virtual interface.
        new_public_virtual_interface_allocation(Dict): Information about the public virtual interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.public_virtual_interface.allocate(
                ctx,
                connection_id=value,
                owner_account=value,
                new_public_virtual_interface_allocation=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.public_virtual_interface.allocate connection_id=value, owner_account=value, new_public_virtual_interface_allocation=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="allocate_public_virtual_interface",
        op_kwargs={
            "connectionId": connection_id,
            "ownerAccount": owner_account,
            "newPublicVirtualInterfaceAllocation": new_public_virtual_interface_allocation,
        },
    )


async def confirm(hub, ctx, virtual_interface_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Accepts ownership of a public virtual interface created by another account. After the virtual interface owner makes this call, the specified virtual interface is created and made available to handle traffic.

    Args:
        virtual_interface_id(str): The ID of the virtual interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.public_virtual_interface.confirm(
                ctx, virtual_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.public_virtual_interface.confirm virtual_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="confirm_public_virtual_interface",
        op_kwargs={"virtualInterfaceId": virtual_interface_id},
    )


async def create(
    hub, ctx, connection_id: str, new_public_virtual_interface: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3. When creating an IPv6 public virtual interface (addressFamily is ipv6), leave the customer and amazon address fields blank to use auto-assigned IPv6 space. Custom IPv6 addresses are not supported.

    Args:
        connection_id(str): The ID of the connection.
        new_public_virtual_interface(Dict): Information about the public virtual interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.public_virtual_interface.create(
                ctx, connection_id=value, new_public_virtual_interface=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.public_virtual_interface.create connection_id=value, new_public_virtual_interface=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_public_virtual_interface",
        op_kwargs={
            "connectionId": connection_id,
            "newPublicVirtualInterface": new_public_virtual_interface,
        },
    )
