"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def allocate(
    hub,
    ctx,
    connection_id: str,
    owner_account: str,
    new_private_virtual_interface_allocation: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Provisions a private virtual interface to be owned by the specified account. Virtual interfaces created using this action must be confirmed by the owner using ConfirmPrivateVirtualInterface. Until then, the virtual interface is in the Confirming state and is not available to handle traffic.

    Args:
        connection_id(str): The ID of the connection on which the private virtual interface is provisioned.
        owner_account(str): The ID of the account that owns the virtual private interface.
        new_private_virtual_interface_allocation(Dict): Information about the private virtual interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.private_virtual_interface.allocate(
                ctx,
                connection_id=value,
                owner_account=value,
                new_private_virtual_interface_allocation=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.private_virtual_interface.allocate connection_id=value, owner_account=value, new_private_virtual_interface_allocation=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="allocate_private_virtual_interface",
        op_kwargs={
            "connectionId": connection_id,
            "ownerAccount": owner_account,
            "newPrivateVirtualInterfaceAllocation": new_private_virtual_interface_allocation,
        },
    )


async def confirm(
    hub,
    ctx,
    virtual_interface_id: str,
    virtual_gateway_id: str = None,
    direct_connect_gateway_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts ownership of a private virtual interface created by another account. After the virtual interface owner makes this call, the virtual interface is created and attached to the specified virtual private gateway or Direct Connect gateway, and is made available to handle traffic.

    Args:
        virtual_interface_id(str): The ID of the virtual interface.
        virtual_gateway_id(str, optional): The ID of the virtual private gateway. Defaults to None.
        direct_connect_gateway_id(str, optional): The ID of the Direct Connect gateway. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.private_virtual_interface.confirm(
                ctx, virtual_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.private_virtual_interface.confirm virtual_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="confirm_private_virtual_interface",
        op_kwargs={
            "virtualInterfaceId": virtual_interface_id,
            "virtualGatewayId": virtual_gateway_id,
            "directConnectGatewayId": direct_connect_gateway_id,
        },
    )


async def create(
    hub, ctx, connection_id: str, new_private_virtual_interface: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW). Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to multiple VPCs, including VPCs in different Regions. Connecting the private virtual interface to a VGW only provides access to a single VPC within the same Region. Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.

    Args:
        connection_id(str): The ID of the connection.
        new_private_virtual_interface(Dict): Information about the private virtual interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.private_virtual_interface.create(
                ctx, connection_id=value, new_private_virtual_interface=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.private_virtual_interface.create connection_id=value, new_private_virtual_interface=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_private_virtual_interface",
        op_kwargs={
            "connectionId": connection_id,
            "newPrivateVirtualInterface": new_private_virtual_interface,
        },
    )
