"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    connection_id: str,
    secret_arn: str = None,
    ckn: str = None,
    cak: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection. You must supply either the secretARN, or the CKN/CAK (ckn and cak) pair in the request. For information about MAC Security (MACsec) key considerations, see MACsec pre-shared CKN/CAK key considerations  in the Direct Connect User Guide.

    Args:
        connection_id(str): The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx). You can use DescribeConnections or DescribeLags to retrieve connection ID.
        secret_arn(str, optional): The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection. You can use DescribeConnections or DescribeLags to retrieve the MAC Security (MACsec) secret key. If you use this request parameter, you do not use the ckn and cak request parameters. Defaults to None.
        ckn(str, optional): The MAC Security (MACsec) CKN to associate with the dedicated connection. You can create the CKN/CAK pair using an industry standard tool.  The valid values are 64 hexadecimal characters (0-9, A-E). If you use this request parameter, you must use the cak request parameter and not use the secretARN request parameter. Defaults to None.
        cak(str, optional): The MAC Security (MACsec) CAK to associate with the dedicated connection. You can create the CKN/CAK pair using an industry standard tool.  The valid values are 64 hexadecimal characters (0-9, A-E). If you use this request parameter, you must use the ckn request parameter and not use the secretARN request parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.mac_sec_key.associate(ctx, connection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.mac_sec_key.associate connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="associate_mac_sec_key",
        op_kwargs={
            "connectionId": connection_id,
            "secretARN": secret_arn,
            "ckn": ckn,
            "cak": cak,
        },
    )


async def disassociate(hub, ctx, connection_id: str, secret_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.

    Args:
        connection_id(str): The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx). You can use DescribeConnections or DescribeLags to retrieve connection ID.
        secret_arn(str): The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key. You can use DescribeConnections to retrieve the ARN of the MAC Security (MACsec) secret key.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.mac_sec_key.disassociate(
                ctx, connection_id=value, secret_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.mac_sec_key.disassociate connection_id=value, secret_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="disassociate_mac_sec_key",
        op_kwargs={"connectionId": connection_id, "secretARN": secret_arn},
    )
