"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    connection_id: str,
    provider_name: str = None,
    loa_content_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG). The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see Requesting Cross Connects at Direct Connect Locations in the Direct Connect User Guide.

    Args:
        connection_id(str): The ID of a connection, LAG, or interconnect.
        provider_name(str, optional): The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect. Defaults to None.
        loa_content_type(str, optional): The standard media type for the LOA-CFA document. The only supported value is application/pdf. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.loa.describe(ctx, connection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.loa.describe connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_loa",
        op_kwargs={
            "connectionId": connection_id,
            "providerName": provider_name,
            "loaContentType": loa_content_type,
        },
    )
