"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, lag_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes all your link aggregation groups (LAG) or the specified LAG.

    Args:
        lag_id(str, optional): The ID of the LAG. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.lags.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.lags.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_lags",
        op_kwargs={"lagId": lag_id},
    )
