"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    number_of_connections: int,
    location: str,
    connections_bandwidth: str,
    lag_name: str,
    connection_id: str = None,
    tags: List = None,
    child_connection_tags: List = None,
    provider_name: str = None,
    request_mac_sec: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single interface. All connections in a LAG must use the same bandwidth (either 1Gbps or 10Gbps) and must terminate at the same Direct Connect endpoint. You can have up to 10 dedicated connections per LAG. Regardless of this limit, if you request more connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created. You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts towards the total number of connections). Doing so interrupts the current physical dedicated connection, and re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are automatically disassociated and re-associated with the LAG. The connection ID does not change. If the account used to create a LAG is a registered Direct Connect Partner, the LAG is automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces cannot be directly configured.

    Args:
        number_of_connections(int): The number of physical dedicated connections initially provisioned and bundled by the LAG.
        location(str): The location for the LAG.
        connections_bandwidth(str): The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values are 1Gbps and 10Gbps. .
        lag_name(str): The name of the LAG.
        connection_id(str, optional): The ID of an existing dedicated connection to migrate to the LAG. Defaults to None.
        tags(List, optional): The tags to associate with the LAG. Defaults to None.
        child_connection_tags(List, optional): The tags to associate with the automtically created LAGs. Defaults to None.
        provider_name(str, optional): The name of the service provider associated with the LAG. Defaults to None.
        request_mac_sec(bool, optional): Indicates whether the connection will support MAC Security (MACsec).  All connections in the LAG must be capable of supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see MACsec prerequisties in the Direct Connect User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.lag.create(
                ctx,
                number_of_connections=value,
                location=value,
                connections_bandwidth=value,
                lag_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.lag.create number_of_connections=value, location=value, connections_bandwidth=value, lag_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_lag",
        op_kwargs={
            "numberOfConnections": number_of_connections,
            "location": location,
            "connectionsBandwidth": connections_bandwidth,
            "lagName": lag_name,
            "connectionId": connection_id,
            "tags": tags,
            "childConnectionTags": child_connection_tags,
            "providerName": provider_name,
            "requestMACSec": request_mac_sec,
        },
    )


async def delete(hub, ctx, lag_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces or hosted connections.

    Args:
        lag_id(str): The ID of the LAG.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.lag.delete(ctx, lag_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.lag.delete lag_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="delete_lag",
        op_kwargs={"lagId": lag_id},
    )


async def update(
    hub,
    ctx,
    lag_id: str,
    lag_name: str = None,
    minimum_links: int = None,
    encryption_mode: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the attributes of the specified link aggregation group (LAG). You can update the following LAG attributes:   The name of the LAG.   The value for the minimum number of connections that must be operational for the LAG itself to be operational.    The LAG's MACsec encryption mode. Amazon Web Services assigns this value to each connection which is part of the LAG.   The tags    If you adjust the threshold value for the minimum number of operational connections, ensure that the new value does not cause the LAG to fall below the threshold and become non-operational.

    Args:
        lag_id(str): The ID of the LAG.
        lag_name(str, optional): The name of the LAG. Defaults to None.
        minimum_links(int, optional): The minimum number of physical connections that must be operational for the LAG itself to be operational. Defaults to None.
        encryption_mode(str, optional): The LAG MAC Security (MACsec) encryption mode. Amazon Web Services applies the value to all connections which are part of the LAG. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.lag.update(ctx, lag_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.lag.update lag_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="update_lag",
        op_kwargs={
            "lagId": lag_id,
            "lagName": lag_name,
            "minimumLinks": minimum_links,
            "encryptionMode": encryption_mode,
        },
    )
