"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    interconnect_name: str,
    bandwidth: str,
    location: str,
    lag_id: str = None,
    tags: List = None,
    provider_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location. An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use an interconnect to provide Direct Connect hosted connections to customers through their own network services. Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect router. You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created. For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling AllocateHostedConnection. The end customer can then connect to Amazon Web Services resources by creating a virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.  Intended for use by Direct Connect Partners only.

    Args:
        interconnect_name(str): The name of the interconnect.
        bandwidth(str): The port bandwidth, in Gbps. The possible values are 1 and 10.
        location(str): The location of the interconnect.
        lag_id(str, optional): The ID of the LAG. Defaults to None.
        tags(List, optional): The tags to associate with the interconnect. Defaults to None.
        provider_name(str, optional): The name of the service provider associated with the interconnect. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.interconnect.init.create(
                ctx, interconnect_name=value, bandwidth=value, location=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.interconnect.init.create interconnect_name=value, bandwidth=value, location=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_interconnect",
        op_kwargs={
            "interconnectName": interconnect_name,
            "bandwidth": bandwidth,
            "location": location,
            "lagId": lag_id,
            "tags": tags,
            "providerName": provider_name,
        },
    )


async def delete(hub, ctx, interconnect_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified interconnect.  Intended for use by Direct Connect Partners only.

    Args:
        interconnect_id(str): The ID of the interconnect.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.interconnect.init.delete(
                ctx, interconnect_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.interconnect.init.delete interconnect_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="delete_interconnect",
        op_kwargs={"interconnectId": interconnect_id},
    )


async def describe_all(hub, ctx, interconnect_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the interconnects owned by the account or only the specified interconnect.

    Args:
        interconnect_id(str, optional): The ID of the interconnect. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.interconnect.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.interconnect.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_interconnects",
        op_kwargs={"interconnectId": interconnect_id},
    )
