"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def allocate(
    hub,
    ctx,
    connection_id: str,
    owner_account: str,
    bandwidth: str,
    connection_name: str,
    vlan: int,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects. Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the specified capacity and the Direct Connect Partner must also police the hosted connection for the specified capacity.  Intended for use by Direct Connect Partners only.

    Args:
        connection_id(str): The ID of the interconnect or LAG.
        owner_account(str): The ID of the account ID of the customer for the connection.
        bandwidth(str): The bandwidth of the connection. The possible values are 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note that only those Direct Connect Partners who have met specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection. .
        connection_name(str): The name of the hosted connection.
        vlan(int): The dedicated VLAN provisioned to the hosted connection.
        tags(List, optional): The tags associated with the connection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.hosted_connection.allocate(
                ctx,
                connection_id=value,
                owner_account=value,
                bandwidth=value,
                connection_name=value,
                vlan=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.hosted_connection.allocate connection_id=value, owner_account=value, bandwidth=value, connection_name=value, vlan=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="allocate_hosted_connection",
        op_kwargs={
            "connectionId": connection_id,
            "ownerAccount": owner_account,
            "bandwidth": bandwidth,
            "connectionName": connection_name,
            "vlan": vlan,
            "tags": tags,
        },
    )


async def associate(hub, ctx, connection_id: str, parent_connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address, the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web Services as it is being migrated.  Intended for use by Direct Connect Partners only.

    Args:
        connection_id(str): The ID of the hosted connection.
        parent_connection_id(str): The ID of the interconnect or the LAG.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.hosted_connection.associate(
                ctx, connection_id=value, parent_connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.hosted_connection.associate connection_id=value, parent_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="associate_hosted_connection",
        op_kwargs={
            "connectionId": connection_id,
            "parentConnectionId": parent_connection_id,
        },
    )


async def describe_all(hub, ctx, connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group (LAG).  Intended for use by Direct Connect Partners only.

    Args:
        connection_id(str): The ID of the interconnect or LAG.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.hosted_connection.describe_all(
                ctx, connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.hosted_connection.describe_all connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_hosted_connections",
        op_kwargs={"connectionId": connection_id},
    )
