"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, direct_connect_gateway_name: str, amazon_side_asn: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Region after it is created. The virtual interfaces and virtual private gateways that are connected through a Direct Connect gateway can be in different Regions. This enables you to connect to a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic between them.

    Args:
        direct_connect_gateway_name(str): The name of the Direct Connect gateway.
        amazon_side_asn(int, optional): The autonomous system number (ASN) for Border Gateway Protocol (BGP) to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294. The default is 64512. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.init.create(
                ctx, direct_connect_gateway_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.init.create direct_connect_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_direct_connect_gateway",
        op_kwargs={
            "directConnectGatewayName": direct_connect_gateway_name,
            "amazonSideAsn": amazon_side_asn,
        },
    )


async def delete(hub, ctx, direct_connect_gateway_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect gateway.

    Args:
        direct_connect_gateway_id(str): The ID of the Direct Connect gateway.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.init.delete(
                ctx, direct_connect_gateway_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.init.delete direct_connect_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="delete_direct_connect_gateway",
        op_kwargs={"directConnectGatewayId": direct_connect_gateway_id},
    )


async def describe_all(
    hub,
    ctx,
    direct_connect_gateway_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect gateways are not returned.

    Args:
        direct_connect_gateway_id(str, optional): The ID of the Direct Connect gateway. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. If MaxResults is given a value larger than 100, only 100 results are returned. Defaults to None.
        next_token(str, optional): The token provided in the previous call to retrieve the next page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_direct_connect_gateways",
        op_kwargs={
            "directConnectGatewayId": direct_connect_gateway_id,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
