"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    direct_connect_gateway_id: str = None,
    virtual_interface_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response contains the attachment between the Direct Connect gateway and the virtual interface.

    Args:
        direct_connect_gateway_id(str, optional): The ID of the Direct Connect gateway. Defaults to None.
        virtual_interface_id(str, optional): The ID of the virtual interface. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. If MaxResults is given a value larger than 100, only 100 results are returned. Defaults to None.
        next_token(str, optional): The token provided in the previous call to retrieve the next page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.attachment.describe_all(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.attachment.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_direct_connect_gateway_attachments",
        op_kwargs={
            "directConnectGatewayId": direct_connect_gateway_id,
            "virtualInterfaceId": virtual_interface_id,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
