"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub,
    ctx,
    direct_connect_gateway_id: str,
    proposal_id: str,
    associated_gateway_owner_account: str,
    override_allowed_prefixes_to_direct_connect_gateway: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.

    Args:
        direct_connect_gateway_id(str): The ID of the Direct Connect gateway.
        proposal_id(str): The ID of the request proposal.
        associated_gateway_owner_account(str): The ID of the account that owns the virtual private gateway or transit gateway.
        override_allowed_prefixes_to_direct_connect_gateway(List, optional): Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway. For information about how to set the prefixes, see Allowed Prefixes in the Direct Connect User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.association.proposal.accept(
                ctx,
                direct_connect_gateway_id=value,
                proposal_id=value,
                associated_gateway_owner_account=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.association.proposal.accept direct_connect_gateway_id=value, proposal_id=value, associated_gateway_owner_account=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="accept_direct_connect_gateway_association_proposal",
        op_kwargs={
            "directConnectGatewayId": direct_connect_gateway_id,
            "proposalId": proposal_id,
            "associatedGatewayOwnerAccount": associated_gateway_owner_account,
            "overrideAllowedPrefixesToDirectConnectGateway": override_allowed_prefixes_to_direct_connect_gateway,
        },
    )


async def create(
    hub,
    ctx,
    direct_connect_gateway_id: str,
    direct_connect_gateway_owner_account: str,
    gateway_id: str,
    add_allowed_prefixes_to_direct_connect_gateway: List = None,
    remove_allowed_prefixes_to_direct_connect_gateway: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified Direct Connect gateway. You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any account.

    Args:
        direct_connect_gateway_id(str): The ID of the Direct Connect gateway.
        direct_connect_gateway_owner_account(str): The ID of the account that owns the Direct Connect gateway.
        gateway_id(str): The ID of the virtual private gateway or transit gateway.
        add_allowed_prefixes_to_direct_connect_gateway(List, optional): The Amazon VPC prefixes to advertise to the Direct Connect gateway. Defaults to None.
        remove_allowed_prefixes_to_direct_connect_gateway(List, optional): The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.association.proposal.create(
                ctx,
                direct_connect_gateway_id=value,
                direct_connect_gateway_owner_account=value,
                gateway_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.association.proposal.create direct_connect_gateway_id=value, direct_connect_gateway_owner_account=value, gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_direct_connect_gateway_association_proposal",
        op_kwargs={
            "directConnectGatewayId": direct_connect_gateway_id,
            "directConnectGatewayOwnerAccount": direct_connect_gateway_owner_account,
            "gatewayId": gateway_id,
            "addAllowedPrefixesToDirectConnectGateway": add_allowed_prefixes_to_direct_connect_gateway,
            "removeAllowedPrefixesToDirectConnectGateway": remove_allowed_prefixes_to_direct_connect_gateway,
        },
    )


async def delete(hub, ctx, proposal_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway or transit gateway.

    Args:
        proposal_id(str): The ID of the proposal.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.association.proposal.delete(
                ctx, proposal_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.association.proposal.delete proposal_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="delete_direct_connect_gateway_association_proposal",
        op_kwargs={"proposalId": proposal_id},
    )


async def describe_all(
    hub,
    ctx,
    direct_connect_gateway_id: str = None,
    proposal_id: str = None,
    associated_gateway_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more association proposals for connection between a virtual private gateway or transit gateway and a Direct Connect gateway.

    Args:
        direct_connect_gateway_id(str, optional): The ID of the Direct Connect gateway. Defaults to None.
        proposal_id(str, optional): The ID of the proposal. Defaults to None.
        associated_gateway_id(str, optional): The ID of the associated gateway. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. If MaxResults is given a value larger than 100, only 100 results are returned. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.association.proposal.describe_all(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.association.proposal.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_direct_connect_gateway_association_proposals",
        op_kwargs={
            "directConnectGatewayId": direct_connect_gateway_id,
            "proposalId": proposal_id,
            "associatedGatewayId": associated_gateway_id,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
