"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    direct_connect_gateway_id: str,
    gateway_id: str = None,
    add_allowed_prefixes_to_direct_connect_gateway: List = None,
    virtual_gateway_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.

    Args:
        direct_connect_gateway_id(str): The ID of the Direct Connect gateway.
        gateway_id(str, optional): The ID of the virtual private gateway or transit gateway. Defaults to None.
        add_allowed_prefixes_to_direct_connect_gateway(List, optional): The Amazon VPC prefixes to advertise to the Direct Connect gateway This parameter is required when you create an association to a transit gateway. For information about how to set the prefixes, see Allowed Prefixes in the Direct Connect User Guide. Defaults to None.
        virtual_gateway_id(str, optional): The ID of the virtual private gateway. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.association.init.create(
                ctx, direct_connect_gateway_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.association.init.create direct_connect_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_direct_connect_gateway_association",
        op_kwargs={
            "directConnectGatewayId": direct_connect_gateway_id,
            "gatewayId": gateway_id,
            "addAllowedPrefixesToDirectConnectGateway": add_allowed_prefixes_to_direct_connect_gateway,
            "virtualGatewayId": virtual_gateway_id,
        },
    )


async def delete(
    hub,
    ctx,
    association_id: str = None,
    direct_connect_gateway_id: str = None,
    virtual_gateway_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the association between the specified Direct Connect gateway and virtual private gateway. We recommend that you specify the associationID to delete the association. Alternatively, if you own virtual gateway and a Direct Connect gateway association, you can specify the virtualGatewayId and directConnectGatewayId to delete an association.

    Args:
        association_id(str, optional): The ID of the Direct Connect gateway association. Defaults to None.
        direct_connect_gateway_id(str, optional): The ID of the Direct Connect gateway. Defaults to None.
        virtual_gateway_id(str, optional): The ID of the virtual private gateway. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.association.init.delete(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.association.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="delete_direct_connect_gateway_association",
        op_kwargs={
            "associationId": association_id,
            "directConnectGatewayId": direct_connect_gateway_id,
            "virtualGatewayId": virtual_gateway_id,
        },
    )


async def describe_all(
    hub,
    ctx,
    association_id: str = None,
    associated_gateway_id: str = None,
    direct_connect_gateway_id: str = None,
    max_results: int = None,
    next_token: str = None,
    virtual_gateway_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:   A Direct Connect gateway The response contains all virtual private gateways and transit gateways associated with the Direct Connect gateway.   A virtual private gateway The response contains the Direct Connect gateway.   A transit gateway The response contains the Direct Connect gateway.   A Direct Connect gateway and a virtual private gateway The response contains the association between the Direct Connect gateway and virtual private gateway.   A Direct Connect gateway and a transit gateway The response contains the association between the Direct Connect gateway and transit gateway.

    Args:
        association_id(str, optional): The ID of the Direct Connect gateway association. Defaults to None.
        associated_gateway_id(str, optional): The ID of the associated gateway. Defaults to None.
        direct_connect_gateway_id(str, optional): The ID of the Direct Connect gateway. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. If MaxResults is given a value larger than 100, only 100 results are returned. Defaults to None.
        next_token(str, optional): The token provided in the previous call to retrieve the next page. Defaults to None.
        virtual_gateway_id(str, optional): The ID of the virtual private gateway or transit gateway. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.association.init.describe_all(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.association.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_direct_connect_gateway_associations",
        op_kwargs={
            "associationId": association_id,
            "associatedGatewayId": associated_gateway_id,
            "directConnectGatewayId": direct_connect_gateway_id,
            "maxResults": max_results,
            "nextToken": next_token,
            "virtualGatewayId": virtual_gateway_id,
        },
    )


async def update(
    hub,
    ctx,
    association_id: str = None,
    add_allowed_prefixes_to_direct_connect_gateway: List = None,
    remove_allowed_prefixes_to_direct_connect_gateway: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified attributes of the Direct Connect gateway association. Add or remove prefixes from the association.

    Args:
        association_id(str, optional): The ID of the Direct Connect gateway association. Defaults to None.
        add_allowed_prefixes_to_direct_connect_gateway(List, optional): The Amazon VPC prefixes to advertise to the Direct Connect gateway. Defaults to None.
        remove_allowed_prefixes_to_direct_connect_gateway(List, optional): The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.direct_connect_gateway.association.init.update(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.direct_connect_gateway.association.init.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="update_direct_connect_gateway_association",
        op_kwargs={
            "associationId": association_id,
            "addAllowedPrefixesToDirectConnectGateway": add_allowed_prefixes_to_direct_connect_gateway,
            "removeAllowedPrefixesToDirectConnectGateway": remove_allowed_prefixes_to_direct_connect_gateway,
        },
    )
