"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def confirm(hub, ctx, connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Confirms the creation of the specified hosted connection on an interconnect. Upon creation, the hosted connection is initially in the Ordering state, and remains in this state until the owner confirms creation of the hosted connection.

    Args:
        connection_id(str): The ID of the hosted connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.connection.init.confirm(ctx, connection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.connection.init.confirm connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="confirm_connection",
        op_kwargs={"connectionId": connection_id},
    )


async def create(
    hub,
    ctx,
    location: str,
    bandwidth: str,
    connection_name: str,
    lag_id: str = None,
    tags: List = None,
    provider_name: str = None,
    request_mac_sec: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a connection between a customer network and a specific Direct Connect location. A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end of the cable is connected to your router, the other to an Direct Connect router. To find the locations for your Region, use DescribeLocations. You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.

    Args:
        location(str): The location of the connection.
        bandwidth(str): The bandwidth of the connection.
        connection_name(str): The name of the connection.
        lag_id(str, optional): The ID of the LAG. Defaults to None.
        tags(List, optional): The tags to associate with the lag. Defaults to None.
        provider_name(str, optional): The name of the service provider associated with the requested connection. Defaults to None.
        request_mac_sec(bool, optional): Indicates whether you want the connection to support MAC Security (MACsec). MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see MACsec prerequisties in the Direct Connect User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.connection.init.create(
                ctx, location=value, bandwidth=value, connection_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.connection.init.create location=value, bandwidth=value, connection_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_connection",
        op_kwargs={
            "location": location,
            "bandwidth": bandwidth,
            "connectionName": connection_name,
            "lagId": lag_id,
            "tags": tags,
            "providerName": provider_name,
            "requestMACSec": request_mac_sec,
        },
    )


async def delete(hub, ctx, connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified connection. Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering with any third parties to connect with the Direct Connect location, you must cancel your service with them separately.

    Args:
        connection_id(str): The ID of the connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.connection.init.delete(ctx, connection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.connection.init.delete connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="delete_connection",
        op_kwargs={"connectionId": connection_id},
    )


async def describe_all(hub, ctx, connection_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Displays the specified connection or all connections in this Region.

    Args:
        connection_id(str, optional): The ID of the connection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.connection.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.connection.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="describe_connections",
        op_kwargs={"connectionId": connection_id},
    )


async def update(
    hub,
    ctx,
    connection_id: str,
    connection_name: str = None,
    encryption_mode: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Direct Connect dedicated connection configuration. You can update the following parameters for a connection:   The connection name   The connection's MAC Security (MACsec) encryption mode.

    Args:
        connection_id(str): The ID of the dedicated connection. You can use DescribeConnections to retrieve the connection ID.
        connection_name(str, optional): The name of the connection. Defaults to None.
        encryption_mode(str, optional): The connection MAC Security (MACsec) encryption mode. The valid values are no_encrypt, should_encrypt, and must_encrypt. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.connection.init.update(ctx, connection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.connection.init.update connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="update_connection",
        op_kwargs={
            "connectionId": connection_id,
            "connectionName": connection_name,
            "encryptionMode": encryption_mode,
        },
    )
