"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, virtual_interface_id: str = None, new_bgp_peer: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a BGP peer on the specified virtual interface. You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web Services resources that also use that address family. If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the same address family as an existing BGP peer on the virtual interface. When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses. For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list for the virtual interface.

    Args:
        virtual_interface_id(str, optional): The ID of the virtual interface. Defaults to None.
        new_bgp_peer(Dict, optional): Information about the BGP peer. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.bgp.peer.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.bgp.peer.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="create_bgp_peer",
        op_kwargs={
            "virtualInterfaceId": virtual_interface_id,
            "newBGPPeer": new_bgp_peer,
        },
    )


async def delete(
    hub,
    ctx,
    virtual_interface_id: str = None,
    asn: int = None,
    customer_address: str = None,
    bgp_peer_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN. You cannot delete the last BGP peer from a virtual interface.

    Args:
        virtual_interface_id(str, optional): The ID of the virtual interface. Defaults to None.
        asn(int, optional): The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration. Defaults to None.
        customer_address(str, optional): The IP address assigned to the customer interface. Defaults to None.
        bgp_peer_id(str, optional): The ID of the BGP peer. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.directconnect.bgp.peer.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.directconnect.bgp.peer.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="directconnect",
        operation="delete_bgp_peer",
        op_kwargs={
            "virtualInterfaceId": virtual_interface_id,
            "asn": asn,
            "customerAddress": customer_address,
            "bgpPeerId": bgp_peer_id,
        },
    )
