"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

     Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is AWS Systems Manager, which can be used to create an OpsItem for each generated insight.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.service_integration.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.service_integration.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="describe_service_integration",
        op_kwargs={},
    )


async def update(hub, ctx, service_integration: Dict) -> Dict:
    r"""
    **Autogenerated function**

     Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is AWS Systems Manager, which can be used to create an OpsItem for each generated insight.

    Args:
        service_integration(Dict):  An IntegratedServiceConfig object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.service_integration.update(
                ctx, service_integration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.service_integration.update service_integration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="update_service_integration",
        op_kwargs={"ServiceIntegration": service_integration},
    )
