"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, resource_collection_type: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns lists AWS resources that are of the specified resource collection type. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks.

    Args:
        resource_collection_type(str):  The type of AWS resource collections to return. The one valid value is CLOUD_FORMATION for AWS CloudFormation stacks. .
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.resource_collection.init.get(
                ctx, resource_collection_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.resource_collection.init.get resource_collection_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="get_resource_collection",
        op_kwargs={
            "ResourceCollectionType": resource_collection_type,
            "NextToken": next_token,
        },
    )


async def update(hub, ctx, action: str, resource_collection: Dict) -> Dict:
    r"""
    **Autogenerated function**

     Updates the collection of resources that DevOps Guru analyzes. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru.

    Args:
        action(str):  Specifies if the resource collection in the request is added or deleted to the resource collection. .
        resource_collection(Dict):  Contains information used to update a collection of AWS resources. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.resource_collection.init.update(
                ctx, action=value, resource_collection=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.resource_collection.init.update action=value, resource_collection=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="update_resource_collection",
        op_kwargs={"Action": action, "ResourceCollection": resource_collection},
    )
