"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, insight_id: str, next_token: str = None, locale: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics and a list of related events.

    Args:
        insight_id(str):  The ID of the requested insight. .
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.
        locale(str, optional): A locale that specifies the language to use for recommendations. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.recommendation.list_all(ctx, insight_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.recommendation.list_all insight_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="list_recommendations",
        op_kwargs={"InsightId": insight_id, "NextToken": next_token, "Locale": locale},
    )
