"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(hub, ctx, config: Dict) -> Dict:
    r"""
    **Autogenerated function**

     Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated.  If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics. If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see Permissions for AWS KMS–encrypted Amazon SNS topics.

    Args:
        config(Dict):  A NotificationChannelConfig object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.notification_channel.add(ctx, config=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.notification_channel.add config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="add_notification_channel",
        op_kwargs={"Config": config},
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).

    Args:
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.notification_channel.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.notification_channel.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="list_notification_channels",
        op_kwargs={"NextToken": next_token},
    )


async def remove(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

     Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations.

    Args:
        id_(str):  The ID of the notification channel to be removed. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.notification_channel.remove(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.notification_channel.remove id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="remove_notification_channel",
        op_kwargs={"Id": id_},
    )
