"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns details about an insight that you specify using its ID.

    Args:
        id_(str):  The ID of the insight. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.insight.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.insight.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="describe_insight",
        op_kwargs={"Id": id_},
    )


async def list_all(
    hub, ctx, status_filter: Dict, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of insights in your AWS account. You can specify which insights are returned by their start time and status (ONGOING, CLOSED, or ANY).

    Args:
        status_filter(Dict):  A filter used to filter the returned insights by their status. You can specify one status filter. .
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.insight.list_all(ctx, status_filter=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.insight.list_all status_filter=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="list_insights",
        op_kwargs={
            "StatusFilter": status_filter,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def search(
    hub,
    ctx,
    start_time_range: Dict,
    type_: str,
    filters: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of insights in your AWS account. You can specify which insights are returned by their start time, one or more statuses (ONGOING, CLOSED, and CLOSED), one or more severities (LOW, MEDIUM, and HIGH), and type (REACTIVE or PROACTIVE).   Use the Filters parameter to specify status and severity search parameters. Use the Type parameter to specify REACTIVE or PROACTIVE in your search.

    Args:
        start_time_range(Dict):  The start of the time range passed in. Returned insights occurred after this time. .
        filters(Dict, optional):  A SearchInsightsFilters object that is used to set the severity and status filters on your insight search. . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.
        type_(str):  The type of insights you are searching for (REACTIVE or PROACTIVE). .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.insight.search(
                ctx, start_time_range=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.insight.search start_time_range=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="search_insights",
        op_kwargs={
            "StartTimeRange": start_time_range,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Type": type_,
        },
    )
