"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, insight_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns the most recent feedback submitted in the current AWS account and Region.

    Args:
        insight_id(str, optional):  The ID of the insight for which the feedback was provided. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.feedback.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.feedback.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="describe_feedback",
        op_kwargs={"InsightId": insight_id},
    )


async def put(hub, ctx, insight_feedback: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

     Collects customer feedback about the specified insight.

    Args:
        insight_feedback(Dict, optional):  The feedback from customers is about the recommendations in this insight. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.feedback.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.feedback.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="put_feedback",
        op_kwargs={"InsightFeedback": insight_feedback},
    )
