"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns an estimate of the monthly cost for DevOps Guru to analyze your AWS resources. For more information, see Estimate your Amazon DevOps Guru costs and Amazon DevOps Guru pricing.

    Args:
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.cost_estimation.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.cost_estimation.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="get_cost_estimation",
        op_kwargs={"NextToken": next_token},
    )


async def start(hub, ctx, resource_collection: Dict, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Starts the creation of an estimate of the monthly cost to analyze your AWS resources.

    Args:
        resource_collection(Dict): The collection of AWS resources used to create a monthly DevOps Guru cost estimate.
        client_token(str, optional): The idempotency token used to identify each cost estimate request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.cost_estimation.start(ctx, resource_collection=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.cost_estimation.start resource_collection=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="start_cost_estimation",
        op_kwargs={
            "ResourceCollection": resource_collection,
            "ClientToken": client_token,
        },
    )
