"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns details about an anomaly that you specify using its ID.

    Args:
        id_(str):  The ID of the anomaly. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.devop_guru.anomaly.init.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.devop_guru.anomaly.init.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="devops-guru",
        operation="describe_anomaly",
        op_kwargs={"Id": id_},
    )
